/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;

public class PathUtil {
    public static final Path GAME_FOLDER = FabricLoader.getInstance().getGameDir().normalize();
    public static final Path MOD_FOLDER = FabricLoader.getInstance().getGameDir().resolve("mods").normalize();
    public static final Path MOD_BAK_FOLDER = MOD_FOLDER.resolve("_bclib_deactivated").normalize();

    public static boolean isChildOf(Path parent, Path child) {
        if (child == null || parent == null) {
            return false;
        }
        parent = parent.toAbsolutePath().normalize();
        child = child.toAbsolutePath().normalize();
        int pCount = parent.getNameCount();
        int cCount = child.getNameCount();
        if (cCount > pCount) {
            return PathUtil.isChildOf(parent, child.getParent());
        }
        if (cCount < pCount) {
            return false;
        }
        return child.equals(parent);
    }

    public static void fileWalker(File path, Consumer<Path> pathConsumer) {
        PathUtil.fileWalker(path, true, pathConsumer);
    }

    public static void fileWalker(File path, boolean recursive, Consumer<Path> pathConsumer) {
        if (!path.exists()) {
            return;
        }
        for (File f : path.listFiles()) {
            if (f.getName().startsWith(".")) continue;
            if (f.isDirectory()) {
                if (!recursive) continue;
                PathUtil.fileWalker(f, pathConsumer);
                continue;
            }
            if (!f.isFile()) continue;
            pathConsumer.accept(f.toPath());
        }
    }

    public static String humanReadableFileSize(long size) {
        int threshold = 2;
        int factor = 1024;
        if (size < 0L) {
            return "? Byte";
        }
        if (size < 2048L) {
            return size + " Byte";
        }
        char[] units = new char[]{'K', 'M', 'G', 'T', 'P'};
        int unitIndex = 0;
        double fSize = size;
        while ((fSize /= 1024.0) > 2048.0 && ++unitIndex < units.length) {
        }
        return String.format("%.1f %ciB", fSize, Character.valueOf(units[unitIndex - 1]));
    }
}

